---
--- Created by Ragman2414.
--- DateTime: 21.02.2022
---


LoadMaintenanceSettingsEvent = {}
LoadMaintenanceSettingsEvent_mt = Class(LoadMaintenanceSettingsEvent, Event)
InitEventClass(LoadMaintenanceSettingsEvent, "LoadMaintenanceSettingsEvent")

LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_WEAR_COST = 1
LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_WEAR_DURATION = 2
LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_REPAIR_COST = 3
LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_REPAIR_DURATION = 4

---Create instance of Event class
function LoadMaintenanceSettingsEvent.emptyNew()
    local self = Event.new(LoadMaintenanceSettingsEvent_mt)
    return self
end


---Create new instance of event
function LoadMaintenanceSettingsEvent.new(wearCost, wearDuration, repairCost, repairDuration)
    local self = LoadMaintenanceSettingsEvent.emptyNew()
    self.wearCost = wearCost
    self.wearDuration = wearDuration
    self.repairCost = repairCost
    self.repairDuration = repairDuration
    return self
end


---Called on client side on join
function LoadMaintenanceSettingsEvent:readStream(streamId, connection)

    if g_server == nil then
        self.wearCost = streamReadInt32(streamId, LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_WEAR_COST)
        self.wearDuration = streamReadInt32(streamId, LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_WEAR_DURATION)
        self.repairCost = streamReadInt32(streamId, LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_REPAIR_COST)
        self.repairDuration = streamReadInt32(streamId, LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_REPAIR_DURATION)

        self:run(connection)
    end


end


    ---Called on server side on join
    function LoadMaintenanceSettingsEvent:writeStream(streamId, connection)

    if(g_r_maintenance.maintenanceCost ~= nil) then
        print(g_r_maintenance.maintenanceCost / 0.25)
        streamWriteInt32(streamId, g_r_maintenance.maintenanceCost / 0.25, LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_REPAIR_COST)
    end
    if( g_r_maintenance.maintenanceDuration ~= nil) then
        print(g_r_maintenance.maintenanceDuration / 0.25)
        streamWriteInt32(streamId, g_r_maintenance.maintenanceDuration / 0.25, LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_REPAIR_DURATION)
    end
    if(g_r_maintenance.wearDuration ~= nil) then
        print(g_r_maintenance.wearDuration / 0.25)
        streamWriteInt32(streamId, g_r_maintenance.wearDuration / 0.25 , LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_WEAR_DURATION)
    end

    if(g_r_maintenance.wearCost ~= nil) then
        print(g_r_maintenance.wearCost / 0.25)
        streamWriteInt32(streamId, g_r_maintenance.wearCost / 0.25, LoadMaintenanceSettingsEvent.NUM_BITS_SETTINGS_WEAR_COST)
    end


    end


    ---Run action on receiving side
    function LoadMaintenanceSettingsEvent:run(connection)
        if g_server ~= nil then
            g_server:broadcastEvent(LoadMaintenanceSettingsEvent.new(
                    g_r_maintenance.wearCost,
                    g_r_maintenance.wearDuration,
                    g_r_maintenance.maintenanceCost,
                    g_r_maintenance.maintenanceDuration), false)
            return
        end

        if(self.wearCost ~= nil) then
            print(self.wearCost)
            g_r_maintenance.maintenanceCost = self.wearCost * 0.25
        end
        if(self.wearDuration  ~= nil) then
            print(self.wearDuration)
            g_r_maintenance.maintenanceDuration = self.wearDuration * 0.25
        end
        if(self.repairCost  ~= nil) then
            print(self.repairCost)
            g_r_maintenance.wearDuration = self.repairCost * 0.25
        end
        if(self.repairDuration  ~= nil) then
            print(self.repairDuration)
            g_r_maintenance.wearCost = self.repairDuration * 0.25
        end

    end


